/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.mu;

import com.cisco.pt.LTV;
import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.impl.UUIDImpl;
import com.cisco.pt.ipc.events.IPCEventManager;
import com.cisco.pt.ipc.sim.Signal;
import com.cisco.pt.mu.MUConInMessage;
import com.cisco.pt.mu.MUConOutMessage;
import com.cisco.pt.mu.MULink;
import com.cisco.pt.mu.MULinkUpdMessage;
import com.cisco.pt.mu.MULinkUpdStatusMessage;
import com.cisco.pt.mu.MUNameUpdMessage;
import com.cisco.pt.mu.MUNegotiationMessage;
import com.cisco.pt.mu.MUPDUMessage;
import com.cisco.pt.mu.MUPortAdvMessage;
import com.cisco.pt.mu.MUSaveNetReqMessage;
import com.cisco.pt.mu.MUSaveNetRespMessage;
import com.cisco.pt.mu.MuEventManager;
import com.cisco.pt.mu.MuSessionState;
import com.cisco.pt.mu.MultiUserMessage;
import com.cisco.pt.mu.PortInfo;
import com.cisco.pt.ptmp.ConnectionNegotiationProperties;
import com.cisco.pt.ptmp.PacketTracerConnection;
import com.cisco.pt.ptmp.PacketTracerReadWorker;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.ptmp.Pipeline;
import com.cisco.pt.ptmp.impl.PacketTracerConnectionImpl;
import com.cisco.pt.ptmp.impl.PacketTracerReadWorkerImpl;
import com.cisco.pt.ptmp.impl.PipelineImpl;
import com.cisco.pt.ptmp.task.AuthenticationTask;
import com.cisco.pt.ptmp.task.ConnectionNegotiationTask;
import com.cisco.pt.ptmp.task.DisconnectTask;
import com.cisco.pt.ptmp.task.KeepAliveTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MUSessionImpl
extends Thread
implements PacketTracerSession {
    private static Log logger = LogFactory.getLog(MUSessionImpl.class);
    private PacketTracerConnection packetTracerConnection;
    private Pipeline pipeline;
    private PacketTracerReadWorker readWorker;
    private IPCEventManager eventManager;
    private Timer timer;
    private long sessionID;
    protected boolean isShutdown = false;
    protected int readErrorCount = 0;
    protected MuSessionState mustate = MuSessionState.STATE_DISCONNECTED;
    protected String localNetwork = "Bridge";
    protected String remoteUsername;
    protected String remoteNetwork;
    protected UUID remoteUUID;
    protected MuEventManager muEventManager;
    protected ArrayList<MULink> links = new ArrayList();
    protected ArrayList<PortInfo> availablePorts = new ArrayList();
    private int outMessageId = 0;
    protected KeepAliveTask keepAliveTask = null;

    public MUSessionImpl(String host, int port, ConnectionNegotiationProperties cnp) throws IOException {
        try {
            this.sessionID = System.nanoTime();
            this.packetTracerConnection = new PacketTracerConnectionImpl(host, port, cnp);
            if (!this.packetTracerConnection.connect()) {
                throw new Error("Unable to connect to Packet Tracer", this.packetTracerConnection.getCurrentStatusThrowable());
            }
            MuSessionState oldstate = this.mustate;
            this.mustate = MuSessionState.STATE_NEGOTIATING;
            if (this.muEventManager != null) {
                this.muEventManager.handleSessionStatusChanged(oldstate, this.mustate);
            }
            ConnectionNegotiationTask connectionNegotiationTask = new ConnectionNegotiationTask(this.packetTracerConnection);
            connectionNegotiationTask.negotiateConnection();
            this.packetTracerConnection.connectLowLevelReadThread();
            this.pipeline = new PipelineImpl(this.packetTracerConnection);
            AuthenticationTask authenticationTask = new AuthenticationTask(this);
            boolean success = authenticationTask.authenticate();
            if (success) {
                this.timer = new Timer(Long.toString(this.sessionID));
                this.keepAliveTask = new KeepAliveTask(this);
                this.timer.schedule((TimerTask)this.keepAliveTask, KeepAliveTask.KEEP_ALIVE_INTERVAL, (long)KeepAliveTask.KEEP_ALIVE_INTERVAL);
                this.eventManager = new IPCEventManager(this);
                this.readWorker = new PacketTracerReadWorkerImpl(this, this.pipeline);
                this.muEventManager = null;
                MUNegotiationMessage mun = new MUNegotiationMessage("Bridge", UUIDImpl.makeRandom());
                Runtime.getRuntime().addShutdownHook(this);
                this.readWorker.start();
                this.eventManager.start();
                this.write(mun);
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"Authentication failed.");
                    logger.warn((Object)"Attempting to disconnecting from Packet Tracer.");
                }
                logger.info((Object)"Closing");
                this.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public void run() {
        logger.info((Object)"exiting...");
        while (this.links.size() > 0) {
            try {
                logger.info((Object)("Attempting to remove link..." + this.links.get(0).toString()));
                this.removeLink(this.links.get(0));
            }
            catch (Exception e) {
                logger.error((Object)("Exception thrown when removing link. " + e.toString()));
                e.printStackTrace();
            }
        }
    }

    public void registerEventManager(MuEventManager mgr) {
        this.muEventManager = mgr;
    }

    public void close() throws IOException {
        if (this.readWorker != null) {
            this.readWorker.shouldStop();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        DisconnectTask disconnectTask = new DisconnectTask(this);
        disconnectTask.disconnect();
        MuSessionState oldstate = this.mustate;
        this.mustate = MuSessionState.STATE_DISCONNECTED;
        if (this.muEventManager != null) {
            this.muEventManager.handleSessionStatusChanged(oldstate, this.mustate);
        }
        this.isShutdown = true;
    }

    protected void emergencyShutdown() {
        block6: {
            try {
                this.isShutdown = true;
                if (this.readWorker != null) {
                    this.readWorker.shouldStop();
                }
                if (this.timer != null) {
                    this.timer.cancel();
                }
                if (this.packetTracerConnection != null) {
                    this.packetTracerConnection.disconnect();
                }
                MuSessionState oldstate = this.mustate;
                this.mustate = MuSessionState.STATE_DISCONNECTED;
                if (this.muEventManager != null) {
                    this.muEventManager.handleSessionStatusChanged(oldstate, this.mustate);
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)t;
            }
        }
    }

    public boolean readWorkerError(Throwable t) {
        ++this.readErrorCount;
        boolean connectionOpen = false;
        try {
            connectionOpen = this.packetTracerConnection.isOpen();
        }
        catch (Throwable t2) {
            logger.error((Object)t2.toString());
            if (t2 instanceof ThreadDeath) {
                throw (ThreadDeath)t2;
            }
            connectionOpen = false;
        }
        if (!connectionOpen || this.readErrorCount > 10000) {
            this.readWorker.shouldStop();
            this.emergencyShutdown();
            return false;
        }
        return true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public IPCEventManager getEventManager() {
        return this.eventManager;
    }

    public PacketTracerConnection connection() {
        return this.packetTracerConnection;
    }

    public Pipeline pipeline() {
        return this.pipeline;
    }

    public Timer timer() {
        return this.timer;
    }

    public boolean isConnected() {
        return this.packetTracerConnection.isConnected();
    }

    public void write(LTV tlv) throws IOException {
        this.pipeline.write(tlv);
    }

    public int sendPdu(Signal pdu, int linkId) throws IOException {
        ++this.outMessageId;
        MUPDUMessage msg = new MUPDUMessage();
        msg.linkId = linkId;
        msg.msgId = this.outMessageId;
        msg.pdu = pdu;
        this.write(msg);
        return this.outMessageId;
    }

    public LTV writeRead(LTV tlv) throws IOException {
        if (tlv.hasResponse()) {
            if (this.readWorker == null) {
                throw new Error("Attempt to send an LTV with a non-blocking response before readWorker initialized; LTV = " + tlv);
            }
            this.readWorker.registerRequest(tlv);
            this.pipeline.write(tlv);
            return this.readWorker.getResponse(tlv);
        }
        if (this.readWorker != null) {
            throw new Error("Attempt to send an LTV with a blocking response after readWorker initialized; LTV = " + tlv);
        }
        this.pipeline.write(tlv);
        try {
            return this.pipeline.read();
        }
        catch (InterruptedException e) {
            throw new IOException("Pipeline read was interrupted");
        }
    }

    public void handleEvent(LTV event) {
        this.eventManager.processEvent((IPCEventLTV)event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMuMessage(LTV msg) {
        if (this.mustate == MuSessionState.STATE_NEGOTIATING) {
            if (msg.getType() == 201) {
                try {
                    this.remoteUsername = ((MUNegotiationMessage)msg).getUsername();
                    this.remoteUUID = ((MUNegotiationMessage)msg).getUuid();
                    MuSessionState oldstate = this.mustate;
                    this.mustate = MuSessionState.STATE_CONNECTED;
                    if (this.muEventManager != null) {
                        this.muEventManager.handleSessionStatusChanged(oldstate, this.mustate);
                    }
                    MUNameUpdMessage namemsg = new MUNameUpdMessage(this.localNetwork);
                    this.write(namemsg);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            } else if (msg.getType() != 200) return;
            return;
        } else {
            if (this.mustate != MuSessionState.STATE_CONNECTED) return;
            if (msg.getType() == MultiUserMessage.PTMP_TYPE_MUPORTADV) {
                MUPortAdvMessage pamsg = (MUPortAdvMessage)msg;
                this.handlePortAdvertisement(pamsg);
                if (this.muEventManager == null) return;
                this.muEventManager.handlePortAdvertisement(pamsg);
                return;
            } else if (msg.getType() == MultiUserMessage.PTMP_TYPE_MULINKUPDATE) {
                MULinkUpdMessage linkup = (MULinkUpdMessage)msg;
                this.handleLinkUpdate(linkup);
                return;
            } else if (msg.getType() == MultiUserMessage.PTMP_TYPE_MULINKUPDATESTATUS) {
                MULinkUpdStatusMessage linkupstat = (MULinkUpdStatusMessage)msg;
                if (this.muEventManager == null) return;
                this.muEventManager.handleLinkUpdateStatus(linkupstat);
                return;
            } else if (msg.getType() == MultiUserMessage.PTMP_TYPE_MUPDU) {
                MUPDUMessage pdu = (MUPDUMessage)msg;
                if (this.muEventManager == null) return;
                this.muEventManager.handlePdu(pdu);
                return;
            } else if (msg.getType() == MultiUserMessage.PTMP_TYPE_MUSAVENETREQ) {
                MUSaveNetReqMessage savereq = (MUSaveNetReqMessage)msg;
                if (this.muEventManager == null) return;
                this.muEventManager.handleSaveNetworkRequest(savereq);
                return;
            } else if (msg.getType() == MultiUserMessage.PTMP_TYPE_MUSAVENETRESP) {
                MUSaveNetRespMessage saveresp = (MUSaveNetRespMessage)msg;
                if (this.muEventManager == null) return;
                this.muEventManager.handleSaveNetworkResponse(saveresp);
                return;
            } else if (msg.getType() == MultiUserMessage.PTMP_TYPE_MUCONIN) {
                MUConInMessage conin = (MUConInMessage)msg;
                if (this.muEventManager == null) return;
                this.muEventManager.handleIncomingConnection(conin);
                return;
            } else if (msg.getType() == MultiUserMessage.PTMP_TYPE_MUCONOUT) {
                MUConOutMessage conout = (MUConOutMessage)msg;
                if (this.muEventManager == null) return;
                this.muEventManager.handleOutgoingConnection(conout);
                return;
            } else {
                if (msg.getType() != MultiUserMessage.PTMP_TYPE_MUNAMEUPDATE) return;
                MUNameUpdMessage nameup = (MUNameUpdMessage)msg;
                this.remoteNetwork = nameup.getName();
                if (this.muEventManager == null) return;
                this.muEventManager.handleNameUpdate(nameup);
            }
        }
    }

    public int addLink(MULink link) throws Exception {
        link.linkId = this.links.size();
        if (link.linkUuid == null) {
            link.linkUuid = UUIDImpl.makeRandom();
        }
        MULinkUpdMessage update = new MULinkUpdMessage();
        update.linkOpId = 0;
        update.opType = MULinkUpdMessage.OP_MAKE;
        update.linkId = link.linkId;
        update.linkUuid = link.linkUuid;
        update.portId = link.localPortId;
        update.deviceType = link.localDeviceType;
        update.cableType = link.localCableType;
        update.portName = link.localPortName;
        update.portType = link.localPortType;
        update.portPower = link.localPortPower;
        update.straightPins = link.localStraightPins;
        update.autoCross = link.localAutoCross;
        update.bandwidth = link.localBandwidth;
        update.fullDuplex = link.localFullDuplex;
        update.autoNegotiate = link.localAutoNego;
        update.bandwidthAutoNegotiate = link.localBWNego;
        update.duplexAutoNegotiate = link.localDuplexNego;
        update.clockRate = link.localClockRate;
        update.dcePort = link.localDcePort;
        update.defaultPowerInline = link.localdefaultPowerInline;
        update.powerInline = link.localpowerInline;
        update.RequirePowerInline = link.localRequirePowerInline;
        update.ProvidingPowerInline = link.localProvidingPowerInline;
        update.DevicePower = link.localDevicePower;
        this.links.add(link);
        this.write(update);
        return link.linkId;
    }

    public void removeLink(MULink link) throws Exception {
        MULinkUpdMessage update = new MULinkUpdMessage();
        update.linkOpId = 0;
        update.opType = MULinkUpdMessage.OP_DISCONNECT;
        update.linkId = link.linkId;
        update.linkUuid = link.linkUuid;
        update.portId = link.localPortId;
        update.cableType = link.localCableType;
        update.portName = link.localPortName;
        update.portType = link.localPortType;
        update.portPower = link.localPortPower;
        update.straightPins = link.localStraightPins;
        update.autoCross = link.localAutoCross;
        update.bandwidth = link.localBandwidth;
        update.fullDuplex = link.localFullDuplex;
        update.autoNegotiate = link.localAutoNego;
        update.bandwidthAutoNegotiate = link.localBWNego;
        update.duplexAutoNegotiate = link.localDuplexNego;
        update.clockRate = link.localClockRate;
        update.dcePort = link.localDcePort;
        update.defaultPowerInline = link.localdefaultPowerInline;
        update.powerInline = link.localpowerInline;
        update.RequirePowerInline = link.localRequirePowerInline;
        update.ProvidingPowerInline = link.localProvidingPowerInline;
        update.DevicePower = link.localDevicePower;
        for (MULink item : this.links) {
            if (item.linkUuid != link.linkUuid) continue;
            this.links.remove(item);
            break;
        }
        this.write(update);
    }

    public void updateLink(MULink link) throws Exception {
        MULinkUpdMessage update = new MULinkUpdMessage();
        update.linkOpId = 0;
        update.opType = MULinkUpdMessage.OP_UPDATE;
        update.linkId = link.linkId;
        update.linkUuid = link.linkUuid;
        update.portId = link.localPortId;
        update.deviceType = link.localDeviceType;
        update.cableType = link.localCableType;
        update.portName = link.localPortName;
        update.portType = link.localPortType;
        update.portPower = link.localPortPower;
        update.straightPins = link.localStraightPins;
        update.autoCross = link.localAutoCross;
        update.bandwidth = link.localBandwidth;
        update.fullDuplex = link.localFullDuplex;
        update.autoNegotiate = link.localAutoNego;
        update.bandwidthAutoNegotiate = link.localBWNego;
        update.duplexAutoNegotiate = link.localDuplexNego;
        update.clockRate = link.localClockRate;
        update.dcePort = link.localDcePort;
        update.defaultPowerInline = link.localdefaultPowerInline;
        update.powerInline = link.localpowerInline;
        update.RequirePowerInline = link.localRequirePowerInline;
        update.ProvidingPowerInline = link.localProvidingPowerInline;
        update.DevicePower = link.localDevicePower;
        for (int i = 0; i < this.links.size(); ++i) {
            MULink item = this.links.get(i);
            if (item.linkUuid != link.linkUuid) continue;
            this.links.set(i, link);
            break;
        }
        this.write(update);
    }

    protected void handlePortAdvertisement(MUPortAdvMessage msg) {
        ArrayList<PortInfo> newports = msg.portInfo;
        this.availablePorts.clear();
        this.availablePorts.addAll(newports);
    }

    public PortInfo getPortAt(int index) throws Exception {
        return this.availablePorts.get(index);
    }

    public int getAvailablePortCount() {
        return this.availablePorts.size();
    }

    public MULink getLinkAt(int index) throws Exception {
        return this.links.get(index);
    }

    public int getAvailableLinkCount() {
        return this.links.size();
    }

    public PortInfo processLinkUpdate(MULinkUpdMessage msg) {
        return null;
    }

    protected void handleLinkUpdate(MULinkUpdMessage msg) {
        UUID uuid = msg.linkUuid;
        if (msg.opType == MULinkUpdMessage.OP_MAKE) {
            MULink mulink = null;
            boolean newlink = true;
            for (int i = 0; i < this.links.size(); ++i) {
                if (!this.links.get((int)i).linkUuid.equals(uuid)) continue;
                mulink = this.links.get(i);
                newlink = false;
                break;
            }
            if (mulink == null || newlink) {
                mulink = new MULink();
            }
            mulink.linkId = msg.linkId;
            mulink.linkUuid = uuid;
            mulink.remotePortId = msg.portId;
            mulink.remoteDeviceType = msg.deviceType;
            mulink.remoteCableType = msg.cableType;
            mulink.remotePortName = msg.portName;
            mulink.remotePortType = msg.portType;
            mulink.remotePortPower = msg.portPower;
            mulink.remoteStraightPins = msg.straightPins;
            mulink.remoteAutoCross = msg.autoCross;
            mulink.remoteBandwidth = msg.bandwidth;
            mulink.remoteFullDuplex = msg.fullDuplex;
            mulink.remoteAutoNego = msg.autoNegotiate;
            mulink.remoteBWNego = msg.bandwidthAutoNegotiate;
            mulink.remoteDuplexNego = msg.duplexAutoNegotiate;
            mulink.remoteClockRate = msg.clockRate;
            mulink.remoteDcePort = msg.dcePort;
            mulink.remotedefaultPowerInline = msg.defaultPowerInline;
            mulink.remotepowerInline = msg.powerInline;
            mulink.remoteRequirePowerInline = msg.RequirePowerInline;
            mulink.remoteProvidingPowerInline = msg.ProvidingPowerInline;
            mulink.remoteDevicePower = msg.DevicePower;
            this.links.add(mulink);
            if (this.muEventManager != null) {
                this.muEventManager.handleLinkUpdate(mulink, newlink ? MULinkUpdMessage.OP_MAKE : MULinkUpdMessage.OP_UPDATE);
            }
        } else {
            MULink link = null;
            for (int j = 0; j < this.links.size(); ++j) {
                if (!this.links.get((int)j).linkUuid.equals(uuid)) continue;
                link = this.links.get(j);
                break;
            }
            if (link == null) {
                return;
            }
            if (msg.opType == MULinkUpdMessage.OP_UPDATE) {
                link.remotePortId = msg.portId;
                link.remoteDeviceType = msg.deviceType;
                link.remoteCableType = msg.cableType;
                link.remotePortName = msg.portName;
                link.remotePortType = msg.portType;
                link.remotePortPower = msg.portPower;
                link.remoteStraightPins = msg.straightPins;
                link.remoteAutoCross = msg.autoCross;
                link.remoteBandwidth = msg.bandwidth;
                link.remoteFullDuplex = msg.fullDuplex;
                link.remoteAutoNego = msg.autoNegotiate;
                link.remoteBWNego = msg.bandwidthAutoNegotiate;
                link.remoteDuplexNego = msg.duplexAutoNegotiate;
                link.remoteClockRate = msg.clockRate;
                link.remoteDcePort = msg.dcePort;
                link.remotedefaultPowerInline = msg.defaultPowerInline;
                link.remotepowerInline = msg.powerInline;
                link.remoteRequirePowerInline = msg.RequirePowerInline;
                link.remoteProvidingPowerInline = msg.ProvidingPowerInline;
                link.remoteDevicePower = msg.DevicePower;
                if (this.muEventManager != null) {
                    this.muEventManager.handleLinkUpdate(link, MULinkUpdMessage.OP_UPDATE);
                }
            } else if (msg.opType == MULinkUpdMessage.OP_DISCONNECT) {
                if (this.muEventManager != null) {
                    this.muEventManager.handleLinkUpdate(link, MULinkUpdMessage.OP_DISCONNECT);
                }
                msg.opType = MULinkUpdMessage.OP_DELETE;
                try {
                    this.write(msg);
                }
                catch (Exception e) {
                    System.err.println("MU Link Update exception ");
                    e.printStackTrace();
                }
            } else if (msg.opType == MULinkUpdMessage.OP_DELETE) {
                for (int k = 0; k < this.links.size(); ++k) {
                    if (this.links.get(k) != link) continue;
                    this.links.remove(k);
                    if (this.muEventManager != null) {
                        this.muEventManager.handleLinkUpdate(link, MULinkUpdMessage.OP_DELETE);
                    }
                    return;
                }
            }
        }
    }

    public KeepAliveTask getKeepAliveTask() {
        return this.keepAliveTask;
    }

    public void handleKeepAlive(LTV msg) {
        this.keepAliveTask.receivedKeepAlive();
    }
}

